#include "win_OpenGLApp.h"

COpenGL33Win32App::COpenGL33Win32App()
{
}

COpenGL33Win32App::~COpenGL33Win32App()
{
}

bool COpenGL33Win32App::Init(HINSTANCE hInstance, char *Title, int Width, int Height)
{
	this->Title = Title;

	// register window class

	WNDCLASSEX WndClassEx;

	memset(&WndClassEx, 0, sizeof(WNDCLASSEX));

	WndClassEx.cbSize = sizeof(WNDCLASSEX);
	WndClassEx.style = CS_OWNDC | CS_HREDRAW | CS_VREDRAW;
	WndClassEx.lpfnWndProc = WndProc;
	WndClassEx.hInstance = hInstance;
	WndClassEx.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	WndClassEx.hIconSm = LoadIcon(NULL, IDI_APPLICATION);
	WndClassEx.hCursor = LoadCursor(NULL, IDC_ARROW);
	WndClassEx.lpszClassName = "OpenGL33Win32App";

	if(RegisterClassEx(&WndClassEx) == 0)
	{
		return false;
	}

	// create window

	DWORD Style = WS_OVERLAPPEDWINDOW | WS_CLIPSIBLINGS | WS_CLIPCHILDREN;

	hWnd = CreateWindowEx(WS_EX_APPWINDOW, WndClassEx.lpszClassName, Title, Style, 0, 0, Width, Height, NULL, NULL, hInstance, NULL);

	if(hWnd == NULL)
	{
		return false;
	}

	// center window and adjust client area to Width x Height pixels

	RECT dRect, wRect, cRect;

	GetWindowRect(GetDesktopWindow(), &dRect);
	GetWindowRect(hWnd, &wRect);
	GetClientRect(hWnd, &cRect);

	wRect.right += Width - cRect.right;
	wRect.bottom += Height - cRect.bottom;
	wRect.right -= wRect.left;
	wRect.bottom -= wRect.top;
	wRect.left = dRect.right / 2 - wRect.right / 2;
	wRect.top = dRect.bottom / 2 - wRect.bottom / 2;

	MoveWindow(hWnd, wRect.left, wRect.top, wRect.right, wRect.bottom, FALSE);

	// set up pixel format

	HDC hDC = GetDC(hWnd);

	if(hDC == NULL)
	{
		return false;
	}

	PIXELFORMATDESCRIPTOR pfd;

	memset(&pfd, 0, sizeof(PIXELFORMATDESCRIPTOR));

	pfd.nSize = sizeof(PIXELFORMATDESCRIPTOR);
	pfd.nVersion = 1;
	pfd.dwFlags = PFD_DOUBLEBUFFER | PFD_SUPPORT_OPENGL | PFD_DRAW_TO_WINDOW;
	pfd.iPixelType = PFD_TYPE_RGBA;
	pfd.cColorBits = 32;
	pfd.cDepthBits = 24;
	pfd.iLayerType = PFD_MAIN_PLANE;

	int PixelFormat = ChoosePixelFormat(hDC, &pfd);

	if(PixelFormat == 0)
	{
		return false;
	}

	if(SetPixelFormat(hDC, PixelFormat, &pfd) == FALSE)
	{
		return false;
	}

	// create OpenGL rendering context

	hGLRC = wglCreateContext(hDC);

	if(hGLRC == NULL)
	{
		return false;
	}
	
	if(wglMakeCurrent(hDC, hGLRC) == FALSE)
	{
		return false;
	}

	// init GLEW

	if(glewInit() != GLEW_OK)
	{
		return false;
	}

	// create OpenGL 3.3 rendering context

	if(WGLEW_ARB_create_context)
	{
		wglDeleteContext(hGLRC);

		int GL33RCAttribs[] =
		{
			WGL_CONTEXT_MAJOR_VERSION_ARB, 3,
			WGL_CONTEXT_MINOR_VERSION_ARB, 3,
			WGL_CONTEXT_FLAGS_ARB, WGL_CONTEXT_FORWARD_COMPATIBLE_BIT_ARB,
			0
		};

		hGLRC = wglCreateContextAttribsARB(hDC, 0, GL33RCAttribs);

		if(hGLRC == NULL)
		{
			return false;
		}

		if(wglMakeCurrent(hDC, hGLRC) == FALSE)
		{
			return false;
		}

	}
	else
	{
		return false;
	}

	if(WGLEW_EXT_swap_control)
	{
		wglSwapIntervalEXT(0);
	}

	// init OpenGL renderer

	if(OpenGL33Control.Init() == false)
	{
		return false;
	}

	// show window

	ShowWindow(hWnd, SW_SHOWNORMAL);

	return true;
}

void COpenGL33Win32App::MessageLoop()
{
	MSG Msg;

	while(GetMessage(&Msg, NULL, 0, 0) > 0)
	{
		TranslateMessage(&Msg);
		DispatchMessage(&Msg);
	}
}

void COpenGL33Win32App::Destroy()
{
	if(GLEW_VERSION_3_3)
	{
		OpenGL33Control.Destroy();
	}

	wglDeleteContext(hGLRC);

	DestroyWindow(hWnd);
}

void COpenGL33Win32App::OnPaint()
{
	static DWORD LastFPSTime = GetTickCount(), LastFrameTime = LastFPSTime, FPS = 0;

	PAINTSTRUCT ps;

	HDC hDC = BeginPaint(hWnd, &ps);

	DWORD Time = GetTickCount();

	float FrameTime = (Time - LastFrameTime) * 0.001f;

	LastFrameTime = Time;

	if(Time - LastFPSTime > 1000)
	{
		char *Text = new char[256];

		sprintf(Text, "%s - %dx%d - FPS: %d - %s", Title, Width, Height, FPS, glGetString(GL_RENDERER));

		SetWindowText(hWnd, Text);

		delete [] Text;

		LastFPSTime = Time;
		FPS = 0;
	}
	else
	{
		FPS++;
	}

	OpenGL33Control.Render(FrameTime);

	SwapBuffers(hDC);

	EndPaint(hWnd, &ps);

	InvalidateRect(hWnd, NULL, FALSE);
}

void COpenGL33Win32App::OnSize(int Width, int Height)
{
	this->Width = Width;
	this->Height = Height;

	OpenGL33Control.Resize(Width, Height);
}

COpenGL33Win32App OpenGL33Win32App;

LRESULT CALLBACK WndProc(HWND hWnd, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_CLOSE:
			PostQuitMessage(0);
			break;

		case WM_PAINT:
			OpenGL33Win32App.OnPaint();
			break;

		case WM_SIZE:
			OpenGL33Win32App.OnSize(LOWORD(lParam), HIWORD(lParam));
			break;

		default:
			return DefWindowProc(hWnd, uiMsg, wParam, lParam);
	}
	return 0;
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR sCmdLine, int iShow)
{
	if(OpenGL33Win32App.Init(hInstance, "OpenGL 3.3 Win32 application - Shaders", 800, 600))
	{
		OpenGL33Win32App.MessageLoop();
	}

	OpenGL33Win32App.Destroy();

	return 0;
}
